package unipotsdam.informatikkiste;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputType;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import java.util.regex.Pattern;


public class StartActivity2 extends Activity implements OnClickListener {

    // UI references.
    private EditText nameView;
    private View mProgressView;
    private View wrongMessage;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        //Remove notification bar
        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_start2);

        // Set up the login form.
        nameView = (EditText) findViewById(R.id.name_text);
        nameView.setInputType(InputType.TYPE_TEXT_FLAG_NO_SUGGESTIONS|InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);

        wrongMessage = findViewById(R.id.wrongTextView);

        Button signInButton = (Button) findViewById(R.id.sign_in_button);
        signInButton.setOnClickListener(this);

        mProgressView = findViewById(R.id.login_progress);
    }

    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.sign_in_button){
            String name = nameView.getText().toString();
            if(Pattern.matches(getResources().getString(R.string.start2_name_solution),name)){
                loginSucces();
            }
            else{
                nameView.setBackgroundColor(getResources().getColor(R.color.colorWrong));
                wrongMessage.setVisibility(View.VISIBLE);
                final Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        nameView.setBackgroundColor(getResources().getColor(R.color.colorTextfield));
                        wrongMessage.setVisibility(View.GONE);
                    }
                }, 2000);
            }
        }
    }

    private void loginSucces(){
        nameView.setBackgroundColor(getResources().getColor(R.color.colorSolved));
        mProgressView.setVisibility(View.VISIBLE);
        mProgressView.setActivated(true);

        Intent intent = new Intent(this, VideoActivity.class);

        final Handler handler = new Handler();
        handler.postDelayed(new StartMainRunnable(intent), getResources().getInteger(R.integer.response_time));
    }

    private class StartMainRunnable implements Runnable{

        Intent intent;

        public StartMainRunnable(Intent intent){
            this.intent = intent;
        }

        @Override
        public void run() {
            startActivity(intent);
            nameView.setBackgroundColor(getResources().getColor(R.color.colorTextfield));
            mProgressView.setActivated(false);
            mProgressView.setVisibility(View.GONE);
        }
    }
}

